using System;
using System.Collections;
using System.IO;
using System.Text;

namespace DesignImplTest
{
	/// <summary>
	/// Wrterbuch zur bersetzung deutscher Wrter in eine andere
	/// Sprache. Das Wrterbuch wird mit einer Wrterdatei 
	/// initialisiert.
	/// </summary>
	public class Dictionary
	{
      /// <summary>
      /// Beinhaltet die Eintrge fr die bersetzung.
      /// </summary>
      private ArrayList _entries = new ArrayList();

      /// <summary>
      /// Konstruktor
      /// </summary>
      /// <param name="filename">
      /// Der Dateiname der bersetzungs-Daten.
      /// </param>
		public Dictionary( string filename )
		{
         this.initializeFromReader( new StreamReader( filename ));
		}

      /// <summary>
      /// Die zu lesende Wrterdatei besteht aus 0 - n Zeichen.
      /// Jede Zeile enthlt einen Eintrag der Form:
      /// deutsches Wort=bersetung
      /// </summary>
      /// <param name="reader">
      /// Der Stream, welcher zum Lesen der bersetzungs-Daten dient.
      /// </param>
	   public void initializeFromReader(StreamReader reader)
	   {
	      string line;
         int index;
         string germanWord;
         string translation;
         Translation entry;

         line = reader.ReadLine();

         while( line != null )
         {
            index = line.IndexOf( "=" );

            if( index != -1 )
            {
               germanWord = line.Substring( 0, index );
               translation = line.Substring( index + 1 );
               entry = new Translation( germanWord, translation );
               _entries.Add( entry );
            }

            line = reader.ReadLine();
         }
	   }

      /// <summary>
      /// Liefert die bersetzung des deutschen Wortes.
      /// Bei mehreren Alternativen werden diese mit Komma
      /// aneinandergehngt.
      /// </summary>
      /// <param name="germanWord">
      /// Das zu bersetzende Wort.
      /// </param>
      /// <returns>
      /// Die gefunden bersetzungen.
      /// </returns>
      public string GetTranslation( string germanWord )
      {
         StringBuilder translations;
         translations = new StringBuilder();

         foreach( Translation entry in _entries )
         {
            if( entry.germanWord == germanWord )
            {
               if( translations.Length > 0 )
               {
                  translations.Append( "," );
               }

               translations.Append( entry.translation );
            }
         }

         return( translations.ToString() );
      }
	}
}
