using DesignImplTest;
using NUnit.Framework;

namespace DesignImplTestFixture
{
	/// <summary>
	/// Klasse zum Testen der Dictionary Funktionalitt.
	/// </summary>
	[TestFixture]
   [Category( "FileAccessNeeded" )]
	public class DictionaryFixture
	{
      #region Member Varibales

      /// <summary>
      /// Beinhaltet das Wrterbuch.
      /// </summary>
      private Dictionary _dictionary;

      #endregion

      #region Test Preparation

	   #region Fixture Setup/TearDown

	   [TestFixtureSetUp]
	   public void FixtureSetUp()
	   {
	      // Keine Implementierung erforderlich.
	   }

	   [TestFixtureTearDown]
	   public void FixtureTearDown()
	   {
	      // Keine Implementierung erforderlich.
	   }

	   #endregion

	   #region Test Case Setup/TearDown

	   [SetUp]
	   public void TestCaseSetUp()
	   {
	      // Keine Implementierung erforderlich.
	   }

	   [TearDown]
	   public void TestCaseTearDown()
	   {
	      // Keine Implementierung erforderlich.
	   }

	   #endregion

	   #endregion

	   #region Tests

	   /// <summary>
	   /// Testet die dictionary Klasse mit 4 
	   /// unterschiedlichen Eintrgen von Testdaten.
	   /// </summary>
	   [Test]
	   public void DictionaryWith4DifferentEntries()
	   {
	      _dictionary = 
            new Dictionary
            ( 
               @"..\..\TestDaten\DictionaryWith4DifferentEntries.txt"
            );

         Assert.IsNotNull( _dictionary );
         Assert
            .AreEqual
            ( 
               "dog", 
               _dictionary.GetTranslation( "Hund" )
            );
	   }

	   /// <summary>
	   /// Testet die dictionary Klasse mit drei 
	   /// gleichen Eintrgen von Testdaten.
	   /// </summary>
	   [Test]
	   public void DictionaryWith3EqualEntries()
	   {
	      _dictionary = 
            new Dictionary
            ( 
               @"..\..\TestDaten\DictionaryWith3EqualEntries.txt"
            );

         Assert.IsNotNull( _dictionary );
         Assert
            .AreEqual
            ( 
               "dog,dog1,dog2", 
               _dictionary.GetTranslation( "Hund" )
            );
	   }

	   /// <summary>
	   /// Testet die dictionary Klasse mit 
	   /// keinen Eintrgen in der Wrterbuchdatei.
	   /// </summary>
	   [Test]
	   public void DictionaryWithNoEntries()
	   {
	      _dictionary = 
            new Dictionary
            ( 
               @"..\..\TestDaten\DictionaryWithNoEntries.txt"
            );
	   }

	   #endregion
	}
}
