// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------

using System;

namespace BRuKE.Article.UseLegacyCppFromCSharp.ManagedCodeInterfaces
{
   /// <summary>
   /// Interface, which abstracts the legacy code functionalty to be able to replace the real 
   /// legacy code with an dummy implementation for test purposes.
   /// </summary>
   public interface ILegacyCodeAdapter
   {
      /// <summary>
      /// Method to start the lagacy code.
      /// </summary>
      /// <param name="managedDelegateContainer">
      /// The container, which contains all delegates, which are used inside the 
      /// legacy code to communicate with the outside .NET managed world.
      /// </param>
      /// <returns>
      /// The output of the legacy code. This output filled up by the managed delegate methods.
      /// </returns>
      /// <exception cref="ArgumentNullException">
      /// If the given delegate container is null.
      /// </exception>
      string StartLegacyCode
      ( 
         ManagedDelegateContainer managedDelegateContainer
      );
   }
}
