#region Copyright
// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------
#endregion

namespace BRuKE.Article.UseLegacyCppFromCSharp.ManagedCodeInterfaces
{
   /// <summary>
   /// Contains all delegates, which should be used out of the unmanaged world.
   /// </summary>
   /// This class, was introduced to be able to add more delegates to the legacy functionality 
   /// without to change several methods, where the delegate methods are given as arguments. 
   /// </remarks>
   public class ManagedDelegateContainer
   {
      #region member variables

      private LoadStringOutOfResourceManagedDelegate m_LoadStringOutOfResourceManagedDelegate;
      private DoSomethingWithAEnumValueManagedDelegate m_DoSomethingWithAEnumValueManagedDelegate;

      #endregion

      #region public properties

      /// <summary>
      /// Get/Set the LoadStringOutOfResourceManagedDelegate, which should be transported by the 
      /// container.
      /// </summary>
      public LoadStringOutOfResourceManagedDelegate LoadStringOutOfResourceManagedDelegate
      {
         get
         {
            return m_LoadStringOutOfResourceManagedDelegate;
         }
         set
         {
            m_LoadStringOutOfResourceManagedDelegate = value;
         }
      }

      /// <summary>
      /// Get/Set the DoSomethingWithAEnumValueManagedDelegate, which should be transported by the 
      /// container.
      /// </summary>
      public DoSomethingWithAEnumValueManagedDelegate DoSomethingWithAEnumValueManagedDelegate
      {
         get
         {
            return m_DoSomethingWithAEnumValueManagedDelegate;
         }
         set
         {
            m_DoSomethingWithAEnumValueManagedDelegate = value;
         }
      }

      #endregion
   }
}
