#region Copyright
// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------
#endregion

using System;

namespace BRuKE.Article.UseLegacyCppFromCSharp.ManagedCodeInterfaces
{
   /// <summary>
   /// Get a string for the legacy code out of the resources, which are placed in the 
   /// managed .NET managed code.
   /// </summary>
   /// <param name="resourceId">
   /// The resource Id.
   /// </param>
   /// <param name="resourceExistsReturnValue">
   /// The value, which indicate, whether a string exists for the given resource 
   /// ID (!=0) or not (0)
   /// </param>
   /// <returns>
   /// The found string or null, if no string exists for the given resource Id.
   /// </returns>
   /// <exception cref="MixedModeCodeException">
   /// If the resource could not be read.
   /// </exception>
   public delegate string LoadStringOutOfResourceManagedDelegate
   ( 
      Int32 resourceId, 
      ref Int32 resourceExistsReturnValue 
   );

   /// <summary>
   /// This delegate delivers for a given managed enum the appropriate Int32 value.
   /// </summary>
   /// <param name="managedEnum">
   /// The managed enum value.
   /// </param>
   /// <returns>
   /// The appropriate Int32 value for the given enum.
   /// </returns>
   /// <exception cref="MixedModeCodeException">
   /// If the return value could not be retrieved.
   /// </exception>
   public delegate Int32 DoSomethingWithAEnumValueManagedDelegate 
   ( 
      ManagedEnum managedEnum
   );                  
}
