#region Copyright
// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------
#endregion

using System;
using System.Runtime.Serialization;

namespace BRuKE.Article.UseLegacyCppFromCSharp.ManagedCodeInterfaces
{
   /// <summary>
   /// Class, which represents the exception, which should be thrown to the consumer of the 
   /// Mixed Mode Code consumewr, so that they have only catch one exception.
   /// </summary>
   public class MixedModeCodeException : ApplicationException
   {
      /// <summary>
      /// Initializes a new instance of the <see cref="MixedModeCodeException"/> class.
      /// </summary>
      /// <param name="message">
      /// The message.
      /// </param>
      /// <param name="innerException">
      /// The inner exception.
      /// </param>
      public MixedModeCodeException( string message, Exception innerException ) : base( message, innerException )
      {
      }

      /// <summary>
      /// Initializes a new instance of the <see cref="MixedModeCodeException"/> class.
      /// </summary>
      /// <param name="message">
      /// The message.
      /// </param>
      public MixedModeCodeException( string message ) : base( message )
      {
      }

      /// <summary>
      /// Initializes a new instance of the <see cref="MixedModeCodeException"/> class.
      /// </summary>
      /// <param name="info">
      /// The object that holds the serialized object data.
      /// </param>
      /// <param name="context">
      /// The contextual information about the source or destination.
      /// </param>
      public MixedModeCodeException( SerializationInfo info, StreamingContext context ) : base( info, context )
      {
      }

      /// <summary>
      /// Initializes a new instance of the <see cref="MixedModeCodeException"/> class.
      /// </summary>
      public MixedModeCodeException()
      {
      }
   }
}
