#region Copyright
// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------
#endregion

using BRuKE.Article.UseLegacyCppFromCSharp.ManagedCode;
using NUnit.Framework;

namespace BRuKE.Article.UseLegacyCppFromCSharp.ManagedCodeTest
{
   /// <summary>
   /// Class, which contains the tests for the functionality, which is provided by the 
   /// Managed Code project.
   /// </summary>
   [TestFixture]
   public class LegacyCodeTest
   {
      [Test(Description="Test, whether the expected information are delivered via a call out of the unmanaged world.")]
      public void CallTheLegacyWorld()
      {
         #region Test preparation

         LegacyCodeFacade legacyCodeFacade;
         legacyCodeFacade = new LegacyCodeFacade();

         Assert.IsNotNull( legacyCodeFacade );

         #endregion

         #region Test

         string legacyInformation;
         legacyInformation = legacyCodeFacade.GetLegacyInformation();

         Assert.AreEqual( "Legacy Resource string;123;Legacy Resource string;321", legacyInformation );

         #endregion
      }
   }
}
