// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------

#ifndef _LEGACYCODE_H_
#define _LEGACYCODE_H_

#if _MSC_VER > 1000
#pragma once
#endif

#include "LegacyCodeCallbackContainer.h"

namespace Legacy
{
   /// <summary>
   /// Class, which represents the legacy code.
   /// </summary>
   class LegacyCode
   {
      public:

         /// <summary>
         /// Constructor.
         /// </summary>
         LegacyCode();      

         /// <summary>
         /// Destructor.
         /// </summary>
         ~LegacyCode(void);

         /// <summary>
         /// Method, which represents the functionalty of the legacy code.
         /// </summary>
         /// <param name="pLegacyCodeCallbackContainer">
         /// The container of the callback methods, which have to be used to get the necessary 
         /// information to execute the functionality.
         /// </param>
         /// <returns>
         /// The created string, based on the functionality of the legacy code.
         /// </returns>
         LPTSTR StartLegacyCode( LegacyCodeCallbackContainer* pLegacyCodeCallbackContainer );
   };
}

#endif