// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------

#ifndef _LEGACYCODEADAPTER_H_
#define _LEGACYCODEADAPTER_H_

#if _MSC_VER > 1000
#pragma once
#endif

#include "LegacyCode.h"
#include "LegacyCodeEnum.h"
#include "LegacyCodeCallbackContainer.h"

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace BRuKE::Article::UseLegacyCppFromCSharp::ManagedCodeInterfaces;
using namespace Legacy;

namespace BRuKE
{
   namespace Article
   {
      namespace UseLegacyCppFromCSharp
      {
         namespace MixedModeCode
         {
            /// <summary>
            /// Class, which connects the legacy code with the outside .NET code.
            /// </summary>
            public ref class LegacyCodeAdapter : ILegacyCodeAdapter
            {
               public:

                  // -----------------------
                  // Infrastructure methods.
                  // -----------------------

                  /// <summary>
                  /// Default constructor.
                  /// </summary>
                  LegacyCodeAdapter();

                  /// <summary>
                  /// Destructor.
                  /// </summary>
                  ~LegacyCodeAdapter();

                  /// <summary>
                  /// Method to start the lagacy code.
                  /// </summary>
                  /// <param name="managedDelegateContainer">
                  /// The container, which contains all delegates, which are used inside the 
                  /// legacy code to communicate with the outside .NET managed world.
                  /// </param>
                  /// <returns>
                  /// The output of the legacy code. This output filled up by the managed delegate methods.
                  /// </returns>
                  /// <exception cref="ArgumentNullException">
                  /// If the given delegate container is null.
                  /// </exception>
                  virtual String^ StartLegacyCode
                  ( 
                     ManagedDelegateContainer^ managedDelegateContainer
                  );

                  // ------------------
                  // Converter methods.
                  // ------------------

                  /// <summary>
                  /// Get a string for the legacy code out of the resources, which are placed in the 
                  /// managed .NET managed code.
                  /// </summary>
                  /// <param name="resourceId">
                  /// The resource Id.
                  /// </param>
                  /// <param name="resourceExistsReturnValue">
                  /// The value, which indicate, whether a string exists for the given resource 
                  /// ID (!=0) or not (0)
                  /// </param>
                  /// <returns>
                  /// The found string or null, if no string exists for the given resource Id.
                  /// </returns>
                  /// <exception cref="MixedModeCodeException">
                  /// If the resource could not be read.
                  /// </exception>
                  LPTSTR LoadStringOutOfResourceConverter
                  (
                     long resourceId,
                     int& resourceExistsReturnValue
                  );

                  /// <summary>
                  /// This delegate delivers for a given unmanaged enum the appropriate long value.
                  /// </summary>
                  /// <param name="lagacyCodeEnum">
                  /// The managed enum value.
                  /// </param>
                  /// <returns>
                  /// The appropriate long value for the given enum.
                  /// </returns>
                  /// <exception cref="MixedModeCodeException">
                  /// If the return value could not be retrieved.
                  /// </exception>
                  long DoSomethingWithAEnumValueConverter
                  ( 
                     LegacyCodeEnum lagacyCodeEnum 
                  );

               private:                  

                  // ---------------------------------------------------------------------------
                  // The delegate container, which are used to communicate with the managed world.
                  // ---------------------------------------------------------------------------  
                  ManagedDelegateContainer^ m_ManagedDelegateContainer;

                  // --------------
                  // Helper Methods
                  // --------------

                  /// <summary>
                  /// The method, which controls the given GCHandle, whether it is allocated
                  /// and it yes, the allocated memory is released.
                  /// </summary>
                  /// <params name="gcHandle">
                  /// The GCHandle to handle.
                  /// </params>
                  void IfGcHandleAllocatedFreeThem( GCHandle gcHandle );
            };
         }
      }
   }
}

#endif