// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------

#ifndef _LEGACYCODEADAPTERDELEGATES_H_
#define _LEGACYCODEADAPTERDELEGATES_H_

#if _MSC_VER > 1000
#pragma once
#endif

#include "LegacyCodeEnum.h"

namespace BRuKE
{
   namespace Article
   {
      namespace UseLegacyCppFromCSharp
      {
         namespace MixedModeCode
         {
            /// <summary>
            /// Get a string out of the resources.
            /// </summary>
            /// <param name="resourceId">
            /// The resource Id.
            /// </param>
            /// <param name="resourceExistsReturnValue">
            /// The value, which indicate, whether a string exists for the given resource 
            /// ID (!=0) or not (0)
            /// </param>
            /// <returns>
            /// The found string or null, if no string exists for the given resource Id.
            /// </returns>
            public delegate LPTSTR LoadStringOutOfResourceMixedModeDelegate
            ( 
               long resourceId, 
               int& resourceExistsReturnValue 
            );

            /// <summary>
            /// This delegate delivers for a given managed enum the appropriate Int32 value.
            /// </summary>
            /// <param name="managedEnum">
            /// The managed enum value.
            /// </param>
            /// <returns>
            /// The appropriate Int32 value for the given enum.
            /// </returns>
            /// <exception cref="MixedModeCodeException">
            /// If the return value could not be retrieved.
            /// </exception>
            public delegate long DoSomethingWithAEnumValueMixedModeDelegate 
            ( 
               LegacyCodeEnum legacyCodeEnum
            );                  
         };
      };
   };
};
#endif