// -------------------------------
// Copyright  2007 Andreas Brsen
// -------------------------------

#ifndef _LegacyCodeCallbackContainer_H_
#define _LegacyCodeCallbackContainer_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "LegacyCodeCallbacks.h"

namespace Legacy
{
   /// <summary>
   /// Contains all callbacks, which should be used in the legacy world.
   /// </summary>
   /// <remarks>
   /// This class, was introduced to be able to add more callback to the legacy functionality 
   /// without to change several methods, where the callback methods are given as arguments. 
   /// </remarks>
   class LegacyCodeCallbackContainer
   {
      public:
      
      /// <summary>
      /// Constructor.
      /// </summary>
      LegacyCodeCallbackContainer()
      {
         LoadStringOutOfResourceUnmanagedCallback = NULL;
      }

      /// <summary>
      /// Destructor.
      /// </summary>
      ~LegacyCodeCallbackContainer(){}

      // Member variables.
      // -----------------
      LegacyCodeCallbacks::LoadStringOutOfResourceUnmanagedCallback LoadStringOutOfResourceUnmanagedCallback;
      LegacyCodeCallbacks::DoSomethingWithAEnumValueUnmanagedCallback DoSomethingWithAEnumValueUnmanagedCallback;
   };
};
#endif