using System.Collections;
using System.IO;

namespace TestDrivenImplTest
{
	/// <summary>
	/// Eine Wrterbuchklasse.
	/// </summary>
	public class Dictionary
	{
      /// <summary>
      /// Hashtable fr die bersetzungen.
      /// </summary>
      private Hashtable _translations;
       
      /// <summary>
      /// Constructor.
      /// </summary>
      /// <param name="FileName">
      /// File Name des zu ladenenden Dictionaries.
      /// </param>
      public Dictionary( string FileName ) : 
         this( new StreamReader( FileName ))
      {
         // Keine Implementierung erforderlich.
      }

      /// <summary>
      /// Constructor.
      /// </summary>
      /// <param name="textReader">
      /// Der TextReader, welcher die Wrter in
      /// der Form &lt;deutschesWort&gt;=&lt;bersetung&gt; 
      /// beinhaltet.
      /// </param>
		public Dictionary( TextReader textReader )
		{
			_translations = new Hashtable();
         readTranslation( textReader );
		}

      /// <summary>
      /// Lese die bersetzungen ein.
      /// </summary>
      /// <param name="textReader">
      /// Der Text Reader, der die Daten liefert.
      /// </param>
	   private void readTranslation( TextReader textReader )
	   {        
	      DictionaryParser dictionaryParser;
         dictionaryParser = new DictionaryParser( textReader );

         string germanWord = string.Empty;
         string translation = string.Empty;

         while( dictionaryParser.HasNextTranslation() )
         {
            germanWord = dictionaryParser.NextGermanWord();
            translation = dictionaryParser.CurrentTranslation();
            this.AddTranslation( germanWord, translation );
         }
	   }

	   /// <summary>
      /// Gibt an, ob das Dictionary leer ist.
      /// </summary>
      /// <returns>
      /// True, wenn das Dictionary leer ist.
      /// </returns>
	   public bool IsEmpty()
	   {
	      return( _translations.Count == 0 );
	   }

      /// <summary>
      /// Fgt eine neue bersetzung hinzu.
      /// </summary>
      /// <param name="germanWord">
      /// Deutsches Wort
      /// </param>
      /// <param name="translatedWord">
      /// bersetztes Wort
      /// </param>
	   public void AddTranslation
      ( 
         string germanWord, 
         string translation 
      )
	   {
         string before;
         before = GetTranslation( germanWord );
         string now;
         if( before == null )
         {
            now = translation;
            _translations.Add( germanWord, now );
         }
         else
         {
            now = before + "," + translation;
            _translations[ germanWord ] = now;
         }
	   }

      /// <summary>
      /// Gibt fr das gegebene deutsche Wort die 
      /// bersetzung zurck.
      /// </summary>
      /// <param name="germanWord">
      /// Das zu bersetzende Wort.
      /// </param>
      /// <returns>
      /// Die verfgbaren bersetzungen.
      /// </returns>
	   public string GetTranslation( string germanWord )
	   {
	      return( (string)_translations[ germanWord ] );
	   }
	}
}
