using System.IO;
using NUnit.Framework;

namespace TestDrivenImplTest
{
   /// <summary>
   /// Klasse zum Testen der Dictionary Funktionalitt
   /// </summary>
   [TestFixture]
   public class DictionaryFixture
   {
      private Dictionary _dictionary;

      [SetUp]
      public void SetUp()
      {
         _dictionary = new Dictionary( new StringReader(""));
      }

      /// <summary>
      /// Testet die Instanzzierung der Klasse Dictionary.
      /// </summary>
      [Test]
      public void Creation()
      {
         Assert.IsTrue( _dictionary.IsEmpty() );
      }

      /// <summary>
      /// Testet das hinzufgen einer bersetzung.
      /// </summary>
      [Test]
      public void OneTranslation()
      {
         _dictionary.AddTranslation( "Buch", "book" );
         Assert.IsFalse( _dictionary.IsEmpty() );

         string Translation;
         Translation = _dictionary.GetTranslation( "Buch" );

         Assert.AreEqual( "book", Translation );
      }

      /// <summary>
      /// Testet das hinzufgen zweier bersetzungen.
      /// </summary>
      [Test]
      public void TwoTranslation()
      {
         _dictionary.AddTranslation( "Buch", "book" );
         _dictionary.AddTranslation( "Auto", "car" );
         Assert.IsFalse( _dictionary.IsEmpty() );
         Assert
            .AreEqual
            ( 
               "book", 
               _dictionary.GetTranslation( "Buch" )
            );
         Assert
            .AreEqual
            ( 
               "car", 
               _dictionary.GetTranslation( "Auto" )
            );
      }

      /// <summary>
      /// Testet das hinzufgen zweier bersetzungen 
      /// fr einen Begriff.
      /// </summary>
      [Test]
      public void TranslationWithTwoEntries()
      {
         _dictionary.AddTranslation( "Buch", "book" );
         _dictionary.AddTranslation( "Buch", "volume" );
         Assert
            .AreEqual
            ( 
               "book,volume", 
               _dictionary.GetTranslation( "Buch" )
            );
      }

      /// <summary>
      /// Testet, ob die Initialisierung des Wrterbuches
      /// mit einer einfachen Datei funktioniert.
      /// </summary>
      [Test]
      public void SimpleFile()
      {
//         Assert.Fail( "dddd");
         _dictionary = new Dictionary( @"..\..\Simple.dic" );
         Assert.IsFalse( _dictionary.IsEmpty() );
      }

      /// <summary>
      /// Das Wrterbuch wird mit zwei bersetzungen initialisiert.
      /// </summary>
      [Test]
      public void TwoTranslationsFromStream()
      {
         string dictionaryInputText;
         dictionaryInputText = 
            "Buch=book\n" +
            "Auto=car";

         StringReader stringReader;
         stringReader = new StringReader( dictionaryInputText );

         _dictionary = new Dictionary( stringReader );
         Assert.IsFalse( _dictionary.IsEmpty() );
         Assert
            .AreEqual
            ( 
               "book", 
               _dictionary.GetTranslation( "Buch" )
            );
         Assert
            .AreEqual
            ( 
               "car", 
               _dictionary.GetTranslation( "Auto" )
            );
      }

      /// <summary>
      /// Testet das Einlesen von zwei bersetungen fr ein
      /// deutsches Wort.
      /// </summary>
      [Test]
      public void TranslationsWithTwoEntriesFromStream()
      {
         string dictionaryInputText;
         dictionaryInputText = 
            "Buch=book\n" +
            "Buch=value";

         StringReader stringReader;
         stringReader = new StringReader( dictionaryInputText );

         _dictionary = new Dictionary( stringReader );

         string translation;
         translation = _dictionary.GetTranslation( "Buch" );

         Assert.AreEqual( "book,value", translation );
      }
   }
}
