// ===================================================
//
// Copyright Andreas Brsen Software Entwicklung
// Schlesierstr.18
// 76275 Ettlingen
//
//
// The copyright to the computer program(s) herein
// is the property of Andreas Brsen, Germany.
// The program(s) may be used and/or copied only with
// the written permission of Andreas Brsen
// or in accordance with the terms and conditions
// stipulated in the agreement/contract under which
// the program(s) have been supplied.
//
// Copyright Version 2005
//
// ===================================================

using System.IO;

namespace TestDrivenImplTest
{
	/// <summary>
	/// Liest die Zeilen in dem bergebenen Stream 
	/// ein und teilt diese auf in das deutsche 
	/// Wort und die jeweilige bersetzung.
	/// </summary>
	public class DictionaryParser
	{
      #region Member Variablen

	   #region 

	   /// <summary>
	   /// Der TextReader, welcher die bergebenen
	   /// Daten bereitstellt.
	   /// </summary>
	   private TextReader _textReader;

	   #endregion

	   /// <summary>
	   /// Beinhaltet die aktuell eingelese Zeile.
	   /// </summary>
	   private string _nextLine = null;

	   /// <summary>
	   /// Beinhaltet die aktuele bersetzung fr das
	   /// deutsche Wort.
	   /// </summary>
	   private string _currentTranslation = null;

	   #endregion

	   /// <summary>
      /// Constructor.
      /// </summary>
      /// <param name="textReader">
      /// Der TextReader, der die Daten liefert.
      /// </param>
		public DictionaryParser( TextReader textReader )
		{
			_textReader = textReader;
		   ReadNextLine();
		}

      /// <summary>
      /// Liest die nchte Zeile im TextReader ein.
      /// </summary>
	   private void ReadNextLine()
	   {
	      _nextLine = _textReader.ReadLine();
	   }

      /// <summary>
      /// Gibt an, ob eine weitere bersetzung existiert.
      /// </summary>
      /// <returns>
      /// True - Eine weitere bersetzung existiert.
      /// </returns>
	   public bool HasNextTranslation()
	   {
	      return( _nextLine != null );
	   }

      /// <summary>
      /// Gibt die das detusche Wort der bersetzung zurck.
      /// </summary>
      /// <returns>
      /// Das deutsche Wort.
      /// </returns>
	   public string NextGermanWord()
	   {
	      int indexOf;
         indexOf = _nextLine.IndexOf( "=" );

         string germanWord;
         germanWord = _nextLine.Substring( 0, indexOf );
         _currentTranslation = _nextLine.Substring( indexOf + 1 );
         this.ReadNextLine();
         
         return( germanWord );
	   }

      /// <summary>
      /// Gibt die bersetzung des aktuellen deutschen 
      /// Wortes zurck.
      /// </summary>
      /// <returns>
      /// Die aktuelle bersetzung.
      /// </returns>
	   public string CurrentTranslation()
	   {
	      return( _currentTranslation );
	   }
	}
}
