using System.IO;
using NUnit.Framework;

namespace TestDrivenImplTest
{
	/// <summary>
	/// Tests fr die DictionaryParser Klasse.
	/// </summary>
	[TestFixture]
	public class DictionaryParserFixture
	{
      #region Memeber Variablen

      /// <summary>
      /// Beinhaltet die Instanz des DictionaryParser,
      /// der jeweils in den Tests benutzt wird.
      /// </summary>
	   private DictionaryParser _dictionaryParser;

	   #endregion

	   #region Hilfs Methoden

      /// <summary>
      /// Erzeugt einen DictionaryParser mit dem bergebenen
      /// Daten.
      /// </summary>
      /// <param name="dictionaryText">
      /// Die bersetzungen, welche die Form haben 
      /// &lt;deutsches Wort&gt;=&lt;bersetzung&gt;
      /// </param>
      /// <returns>
      /// Die erzeugte DictionaryParser Instanz.
      /// </returns>
	   private DictionaryParser CreateParser
	   ( 
	      string dictionaryText 
	   )
	   {
	      StringReader stringReader;
	      stringReader = new StringReader( dictionaryText );

	      return( new DictionaryParser( stringReader ) );
	   }

      /// <summary>
      /// berprft, ob der nchste Eintrag in den
      /// Daten fr das Wrterbuch den bergebenen 
      /// Wrtern entspricht.
      /// </summary>
      /// <param name="germanWord">
      /// Das deutsche Wort.
      /// </param>
      /// <param name="translation">
      /// Die bersetzung.
      /// </param>
	   private void AssertNextTranslation
	   ( 
	      string germanWord, 
	      string translation 
	   )
	   {
	      Assert.IsTrue( _dictionaryParser.HasNextTranslation() );
	      Assert.AreEqual( germanWord, _dictionaryParser.NextGermanWord() );
	      Assert.AreEqual( translation, _dictionaryParser.CurrentTranslation() );
	   }

	   #endregion

	   /// <summary>
      /// Leere Wrterbuch Intialisierung.
      /// </summary>
      [Test]
      public void EmptyStream()
      {
         _dictionaryParser = this.CreateParser( "" );
         Assert.IsFalse( _dictionaryParser.HasNextTranslation());
      }

      /// <summary>
      /// Fgt eine bersetzung in das Wrterbuch ein.
      /// </summary>
      [Test]
      public void OneLine()
      {
         string dictionaryText;
         dictionaryText = "Buch=book";
         _dictionaryParser = this.CreateParser( dictionaryText );

         this.AssertNextTranslation( "Buch", "book" );
         Assert.IsFalse( _dictionaryParser.HasNextTranslation());
      }

      /// <summary>
      /// Fgt drei bersetzungen in das Wrterbuch ein.
      /// </summary>
      [Test]
      public void ThreeLines()
      {
         string dictionaryText;
         dictionaryText = "Buch=book\nAuto=car\nBuch=volume";
         _dictionaryParser = this.CreateParser( dictionaryText );
         this.AssertNextTranslation( "Buch", "book");
         this.AssertNextTranslation( "Auto", "car" );
         this.AssertNextTranslation( "Buch", "volume" );
         Assert.IsFalse( _dictionaryParser.HasNextTranslation() );
      }
	}
}
